#include <stdio.h>
#include <stdlib.h>

typedef struct {
    long long x, y;
    int index;
} Vektor;

int main() {
    int N;
    if (scanf("%d", &N) != 1 || N < 1) return 1;

    Vektor *vektori = (Vektor *)malloc(N * sizeof(Vektor));
    int *izabrano = (int *)calloc(N, sizeof(int));
    if (vektori == NULL || izabrano == NULL) {
        if (vektori) free(vektori);
        return 1;
    }

    for (int i = 0; i < N; i++) {
        if (scanf("%lld %lld", &vektori[i].x, &vektori[i].y) != 2) {
             free(vektori); free(izabrano);
             return 1;
        }
        vektori[i].index = i + 1;
    }

    long long Rx = 0;
    long long Ry = 0;
    
    int promena = 1;
    while (promena) {
        promena = 0;
        
        for (int i = 0; i < N; i++) {
            long long xi = vektori[i].x;
            long long yi = vektori[i].y;
            
            if (izabrano[i]) {
                long long novi_kvad = (Rx - xi) * (Rx - xi) + (Ry - yi) * (Ry - yi);
                long long trenutni_kvad = Rx * Rx + Ry * Ry;

                if (novi_kvad > trenutni_kvad) {
                    Rx -= xi;
                    Ry -= yi;
                    izabrano[i] = 0;
                    promena = 1;
                }
            } 
            else {
                long long novi_kvad = (Rx + xi) * (Rx + xi) + (Ry + yi) * (Ry + yi);
                long long trenutni_kvad = Rx * Rx + Ry * Ry;
                
                if (novi_kvad > trenutni_kvad) {
                    Rx += xi;
                    Ry += yi;
                    izabrano[i] = 1;
                    promena = 1;
                }
            }
        }
    }

    int k = 0;
    for (int i = 0; i < N; i++) {
        if (izabrano[i]) {
            k++;
        }
    }

    printf("%d\n", k);
    
    int prvi = 1;
    for (int i = 0; i < N; i++) {
        if (izabrano[i]) {
            if (!prvi) {
                printf(" ");
            }
            printf("%d", vektori[i].index);
            prvi = 0;
        }
    }
    if (k > 0) {
        printf("\n");
    }

    free(vektori); 
    free(izabrano);

    return 0;
}